import math

def compute_integral_recursive(a, b, n):
    """
    Compute the definite integral of x^n * e^x from a to b using the recursive formula.

    Args:
    a (float): The lower limit of integration.
    b (float): The upper limit of integration.
    n (int): The power of x in the integral.

    Returns:
    float: The numerical value of the definite integral.
    """
    # Base case: I_0 = e^x evaluated from a to b
    if n == 0:
        return math.exp(b) - math.exp(a)
    
    # Recursive case: I_n = [x^n * e^x]_a^b - n * I_{n-1}
    # Compute the term [x^n * e^x] at limits
    term_b = (b**n) * math.exp(b)
    term_a = (a**n) * math.exp(a)
    
    # Compute I_{n-1} recursively
    integral_I_n_minus_1 = compute_integral_recursive(a, b, n - 1)
    
    # Combine results for I_n
    return (term_b - term_a) - n * integral_I_n_minus_1

a = int(input().strip())
b = float(input())
n = float(input())

# Compute using recursive formula
recursive_result = compute_integral_recursive(a, b, n)

# Output the results
print(recursive_result)